unit Micons;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Mask, Mcombbox, MultLang;

type
  TIcons = class(TForm)
    Label1: TLabel;
    MultLang1: TMultLang;
    Label3: TLabel;
    Label4: TLabel;
    CheckBox1: TCheckBox;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Label2: TLabel;
    Label5: TLabel;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CheckBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure MultLang1Translated(Sender: TObject; LanguageName: String;
      Successful: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Icons: TIcons;

implementation

{$R *.DFM}

procedure TIcons.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action:=caFree;
end;

procedure TIcons.CheckBox1Click(Sender: TObject);
begin
  MultLang1.ResizeIcon:=CheckBox1.Checked;
end;

procedure TIcons.ComboBox1Change(Sender: TObject);
begin
  case ComboBox1.ItemIndex of
    0 : MultLang1.AlignIcon:=alLeft;
    1 : MultLang1.AlignIcon:=alCenter;
    2 : MultLang1.AlignIcon:=alRight;
  end;
end;

procedure TIcons.ComboBox2Change(Sender: TObject);
begin
  case ComboBox2.ItemIndex of
    0 : MultLang1.AlignText:=alLeft;
    1 : MultLang1.AlignText:=alCenter;
    2 : MultLang1.AlignText:=alRight;
  end;
end;

procedure TIcons.ComboBox3Change(Sender: TObject);
begin
  MultLang1.IconMargin:=ComboBox3.ItemIndex;
end;

procedure TIcons.ComboBox4Change(Sender: TObject);
begin
  MultLang1.TextMargin:=ComboBox4.ItemIndex;
end;

procedure TIcons.MultLang1Translated(Sender: TObject; LanguageName: String;
  Successful: Boolean);
begin
  CheckBox1.Checked:=MultLang1.ResizeIcon;
  case MultLang1.AlignIcon of
    alLeft   : ComboBox1.ItemIndex:=0;
    alCenter : ComboBox1.ItemIndex:=1;
    alRight  : ComboBox1.ItemIndex:=2;
  end;
  case MultLang1.AlignText of
    alLeft   : ComboBox2.ItemIndex:=0;
    alCenter : ComboBox2.ItemIndex:=1;
    alRight  : ComboBox2.ItemIndex:=2;
  end;
  ComboBox3.ItemIndex:=MultLang1.IconMargin;
  ComboBox4.ItemIndex:=MultLang1.TextMargin;
end;

end.
